﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using TwoCamWPF.Helpers;
using System.Xml;
using System.Reflection;

namespace TwoCamWPF.Settings
{
    class RecordSettings: ISubSettings
    {
        public string SaveFolder { get; set; }
        public int FilesCount { get; set; }
        public int FileLength { get; set; }
        public string FavoritFolder {get; set;}
        public int BitRate { get; set; }
    
        public void  Load(XmlNode node)
        {
            Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Загрузка параметров архива");
            foreach (XmlNode child in node.ChildNodes)
            {
                try
                {
                    switch (child.Name)
                    {
                        case "SaveFolder":
                            SaveFolder = child.InnerXml;
                            break;
                        case "FilesCount":
                            FilesCount = Convert.ToInt32(child.InnerXml);
                            break;
                        case "FileLength":
                            FileLength = Convert.ToInt32(child.InnerXml);
                            break;
                        case "FavoritFolder":
                            FavoritFolder = child.InnerXml;
                            break;
                        case "BitRate":
                            BitRate = Convert.ToInt32(child.InnerXml);
                            break;
                    }
                }
                catch (Exception e)
                {
                    Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "!!!Ошибка загрузки парамтеров архива " + e.Message);
                    Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "На узле " + child.Name);
                }
            }
            if (!Helpers.DirectoryWriteChecker.Process(SaveFolder))
            {
                string AppPath =
            System.IO.Path.GetDirectoryName(
                   System.Windows.Forms.Application.ExecutablePath);//Environment.SpecialFolder..MyComputer;
          
                if (DirectoryWriteChecker.Process(AppPath))
                    SaveFolder = AppPath;
                else
                    SaveFolder = Environment.SpecialFolder.MyDocuments.ToString();
          
            }
        }

        public void  Write(XmlWriter output)
        {
            try
            {
                Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Сохранение параметров архива");
                output.WriteStartElement("RecordSettings", "");
                output.WriteElementString("SaveFolder", SaveFolder.ToString());
                output.WriteElementString("FilesCount", FilesCount.ToString());
                output.WriteElementString("FileLength", FileLength.ToString());
                output.WriteElementString("FavoritFolder", FavoritFolder.ToString());
                output.WriteElementString("BitRate", BitRate.ToString());
                output.WriteEndElement();
            }
            catch (Exception e)
            {
                Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Ошибка сохранения параметров архива");
                Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), e.Message);
            }
        }

        public void  Save()
        {
 	        if (OnSave != null)
                OnSave(this);
        }

        public event Action<ISubSettings>  OnSave;

        public RecordSettings()
        {
            string AppPath = 
             System.IO.Path.GetDirectoryName(
                    System.Windows.Forms.Application.ExecutablePath);//Environment.SpecialFolder..MyComputer;
            if (DirectoryWriteChecker.Process(AppPath))
                SaveFolder = AppPath;
            else
                SaveFolder = Environment.SpecialFolder.MyDocuments.ToString();
            FilesCount = 10;
            FileLength = 600;
            FavoritFolder = SaveFolder + "\\Saved";
            BitRate = 25;
        }
     }
}
